import {createSelector} from 'reselect';

import {EAviaResultsSortType} from 'reducers/avia/search/results/EAviaResultsSortType';

import {sortVariantsGroups} from 'selectors/avia/search/sorting/sortVariantsGroup';
import {getFilteredGroupedVariants} from 'selectors/avia/search/getFilteredGroupedVariants';
import {priceComparatorSelector} from 'selectors/common/currenciesSelector';

import {ESortDirection} from 'projects/avia/lib/comparators/TComparator';

export const getSortedByPriceVariants = createSelector(
    getFilteredGroupedVariants,
    priceComparatorSelector,
    (filteredVariants, priceComparator) =>
        sortVariantsGroups(
            filteredVariants,
            {
                type: EAviaResultsSortType.PRICE,
                direction: ESortDirection.ASCENDING,
            },
            priceComparator,
        ),
);
