import {IAviaSearchResultsSorting} from 'reducers/avia/search/results/reducer';
import {EAviaResultsSortType} from 'reducers/avia/search/results/EAviaResultsSortType';

import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';

import {compareVariantsByPrice} from 'projects/avia/lib/search/comparators/variantsPriceComparator';
import {compareVariantsByDepartureTime} from 'projects/avia/lib/search/comparators/variantsDepartureComparator';
import {compareVariantsByDuration} from 'projects/avia/lib/search/comparators/variantsDurationComparator';
import {compareVariantsByArrivalTime} from 'projects/avia/lib/search/comparators/variantsArrivalComparator';
import {PriceComparator} from 'utilities/currency/compare';

export function sortVariantsGroups(
    variants: IAviaVariantGroup[],
    sorting: IAviaSearchResultsSorting,
    priceComparator: PriceComparator,
): IAviaVariantGroup[] {
    const compareByPrice = compareVariantsByPrice(priceComparator);

    switch (sorting.type) {
        case EAviaResultsSortType.PRICE:
        case EAviaResultsSortType.INTEREST:
            return variants.sort(
                (a, b) =>
                    compareByPrice(a, b, sorting.direction) ||
                    compareVariantsByDepartureTime(a, b, sorting.direction) ||
                    compareVariantsByDuration(a, b, sorting.direction),
            );
        case EAviaResultsSortType.DEPARTURE:
            return variants.sort(
                (a, b) =>
                    compareVariantsByDepartureTime(a, b, sorting.direction) ||
                    compareByPrice(a, b, sorting.direction) ||
                    compareVariantsByDuration(a, b, sorting.direction),
            );
        case EAviaResultsSortType.ARRIVAL:
            return variants.sort(
                (a, b) =>
                    compareVariantsByArrivalTime(a, b, sorting.direction) ||
                    compareByPrice(a, b, sorting.direction) ||
                    compareVariantsByDepartureTime(a, b, sorting.direction),
            );
        case EAviaResultsSortType.DURATION:
            return variants.sort(
                (a, b) =>
                    compareVariantsByDuration(a, b, sorting.direction) ||
                    compareByPrice(a, b, sorting.direction) ||
                    compareVariantsByDepartureTime(a, b, sorting.direction),
            );
    }
}
