import {filtersHashSelector} from 'selectors/avia/search/filters/filtersHashSelector';
import {getAviaCalendarPrices} from 'selectors/avia/aviaSelectors';
import {fromFieldSelector} from 'selectors/avia/searchForm/fromFieldSelector';
import {toFieldSelector} from 'selectors/avia/searchForm/toFieldSelector';
import {startDateSelector} from 'selectors/avia/searchForm/startDateSelector';
import {endDateSelector} from 'selectors/avia/searchForm/endDateSelector';
import {searchSuggestsSelector} from 'selectors/avia/searchForm/searchSuggestsSelector';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export default createTypedStructuredSelector({
    fromField: fromFieldSelector,
    toField: toFieldSelector,
    startDateField: startDateSelector,
    endDateField: endDateSelector,
    isRoundTripField: state => state.avia.searchForm.isRoundTrip,
    adultsField: state => state.avia.searchForm.adults,
    childrenField: state => state.avia.searchForm.children,
    infantsField: state => state.avia.searchForm.infants,
    aviaClassField: state => state.avia.searchForm.aviaClass,
    searchSuggests: searchSuggestsSelector,
    calendar: getAviaCalendarPrices,
    filtersHash: filtersHashSelector,
});
