import {IInlineSearchInfo} from 'types/avia/landing/IInlineSearchInfo';
import {TSettlementKey} from 'types/PointKey';

import {StoreInterface} from 'reducers/storeTypes';
import {IAviaSearchToAnywhereState} from 'reducers/avia/searchToAnywhere/reducer';

const searchToAnywhereSelector = (
    state: StoreInterface,
): IAviaSearchToAnywhereState => state.avia.searchToAnywhere;

/**
 * Статус похода за данными в бэкенд для страницы поиска в страну
 */
export const searchToAnywhereStatusSelector = (
    state: StoreInterface,
): IAviaSearchToAnywhereState['status'] =>
    searchToAnywhereSelector(state).status;

/**
 * Исходные данные для запроса на бэкенд для страницы поиска в страну
 */
export const searchToAnywhereRequestParamsSelector = (
    state: StoreInterface,
): IAviaSearchToAnywhereState['requestParams'] =>
    searchToAnywhereSelector(state).requestParams;

/**
 * Данные о точке отправления для страницы поиска в страну
 */
export const searchToAnywhereFromPointSelector = (
    state: StoreInterface,
): IAviaSearchToAnywhereState['fromPoint'] =>
    searchToAnywhereSelector(state).fromPoint;

/**
 * Данные о городах для страницы поиска в страну
 */
export const searchToAnywhereSettlementsSelector = (
    state: StoreInterface,
): IAviaSearchToAnywhereState['settlements'] =>
    searchToAnywhereSelector(state).settlements;

/**
 * Данные инлайн-поисков для городов для страници поиска в страну
 */
export const searchToAnywhereInlineSearchesSelector = (
    state: StoreInterface,
): IAviaSearchToAnywhereState['inlineSearches'] =>
    searchToAnywhereSelector(state).inlineSearches;

/**
 * Данные инлайн поиска для конкретного города по объекту
 * с инлайн-поисками
 */
export const searchToAnywhereGetInlineSearchDataForCity = (
    inlineSearches: IAviaSearchToAnywhereState['inlineSearches'],
    cityKey: TSettlementKey,
): IInlineSearchInfo | undefined => inlineSearches[cityKey];

/**
 * Данные инлайн поиска для конкретного города на странице поиска куда угодно
 */
export const searchToAnywhereInlineSearchDataForCitySelector = (
    state: StoreInterface,
    cityKey: TSettlementKey,
): IInlineSearchInfo | undefined =>
    searchToAnywhereGetInlineSearchDataForCity(
        searchToAnywhereInlineSearchesSelector(state),
        cityKey,
    );
