import {IInlineSearchInfo} from 'types/avia/landing/IInlineSearchInfo';
import {TSettlementKey} from 'types/PointKey';

import {StoreInterface} from 'reducers/storeTypes';
import {IAviaSearchToCountryState} from 'reducers/avia/searchToCountry/reducer';

const searchToCountrySelector = (
    state: StoreInterface,
): IAviaSearchToCountryState => state.avia.searchToCountry;

/**
 * Статус похода за данными в бэкенд для страницы поиска в страну
 */
export const searchToCountryStatusSelector = (
    state: StoreInterface,
): IAviaSearchToCountryState['status'] => searchToCountrySelector(state).status;

/**
 * Исходные данные для запроса на бэкенд для страницы поиска в страну
 */
export const searchToCountryRequestParamsSelector = (
    state: StoreInterface,
): IAviaSearchToCountryState['requestParams'] =>
    searchToCountrySelector(state).requestParams;

/**
 * Данные о точке отправления для страницы поиска в страну
 */
export const searchToCountryFromPointSelector = (
    state: StoreInterface,
): IAviaSearchToCountryState['fromPoint'] =>
    searchToCountrySelector(state).fromPoint;

/**
 * Данные о стране прибытия для страницы поиска в страну
 */
export const searchToCountryToCountrySelector = (
    state: StoreInterface,
): IAviaSearchToCountryState['toCountry'] =>
    searchToCountrySelector(state).toCountry;

/**
 * Данные о городах для страницы поиска в страну
 */
export const searchToCountrySettlementsSelector = (
    state: StoreInterface,
): IAviaSearchToCountryState['settlements'] =>
    searchToCountrySelector(state).settlements;

/**
 * Данные инлайн-поисков для городов для страници поиска в страну
 */
export const searchToCountryInlineSearchesSelector = (
    state: StoreInterface,
): IAviaSearchToCountryState['inlineSearches'] =>
    searchToCountrySelector(state).inlineSearches;

/**
 * Данные инлайн поиска для конкретного города по объекту
 * с инлайн-поисками
 */
export const searchToCountryGetInlineSearchDataForCity = (
    inlineSearches: IAviaSearchToCountryState['inlineSearches'],
    cityKey: TSettlementKey,
): IInlineSearchInfo | undefined => inlineSearches[cityKey];

/**
 * Данные инлайн поиска для конкретного города
 */
export const searchToCountryInlineSearchDataForCitySelector = (
    state: StoreInterface,
    cityKey: TSettlementKey,
): IInlineSearchInfo | undefined =>
    searchToCountryGetInlineSearchDataForCity(
        searchToCountryInlineSearchesSelector(state),
        cityKey,
    );
