import {createSelector} from 'reselect';

import TValidDataForRequestTableDynamic from 'types/avia/dynamic/TValidDataForRequestTableDynamic';

import {
    tableDynamicForFiltersSelector,
    tableDynamicForSearchFormSelector,
} from 'selectors/avia/tableDynamic/tableDynamicSeletors';

/**
 * Возвращает данные о том с какими данными производился/производится запрос для табличного представления динамики
 */
const tableDynamicCurrentRequestParamsSelector = createSelector(
    tableDynamicForSearchFormSelector,
    tableDynamicForFiltersSelector,
    (searchForm, filters): TValidDataForRequestTableDynamic | null => {
        if (!searchForm || !filters) {
            return null;
        }

        return {
            searchForm,
            filters,
        };
    },
);

export default tableDynamicCurrentRequestParamsSelector;
