import {createSelector} from 'reselect';

import {EDynamicsDayStatus} from 'projects/avia/components/Dynamics/types/IDynamicsDay';

import {TDynamicsDaysInfo} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import {getAviaMinSearchPrice} from 'selectors/avia/search/getMinSearchPrice';
import {getAviaSearchFilters} from 'selectors/avia/search/aviaSearchResultsSelector';
import {aviaContextSearchFormSelector} from 'selectors/avia/context/aviaContextSearchFormSelector';
import {tableDynamicPricesSelector} from 'selectors/avia/tableDynamic/tableDynamicSeletors';
import tableDynamicCurrentRequestParamsSelector from 'selectors/avia/tableDynamic/tableDynamicCurrentRequestParamsSelector';

import isDateRobot from 'utilities/dateUtils/isDateRobot';
import isCompatibleSearchForm from 'projects/avia/lib/dynamic/isCompatibleSearchForm';
import isSameSearchFilters from 'projects/avia/lib/dynamic/isSameSearchFilters';
import getKeyForTablePrice from 'projects/avia/lib/dynamic/getKeyForTablePrice';

const DEFAULT_PRICES = {};

/**
 * Если будет возможно, то к ценам динамики будет добавлена актуальная цена с поиска
 */
const tableDynamicFinalPricesSelector = createSelector(
    tableDynamicPricesSelector,
    tableDynamicCurrentRequestParamsSelector,
    getAviaMinSearchPrice,
    getAviaSearchFilters,
    aviaContextSearchFormSelector,
    (
        prices,
        currentRequestParams,
        minSearchPrice,
        searchFilters,
        searchForm,
    ): TDynamicsDaysInfo => {
        const {when, return_date: returnDate} = searchForm;

        if (
            minSearchPrice &&
            isDateRobot(when) &&
            isDateRobot(returnDate) &&
            currentRequestParams &&
            isCompatibleSearchForm(
                searchForm,
                currentRequestParams.searchForm,
            ) &&
            isSameSearchFilters(searchFilters, currentRequestParams.filters)
        ) {
            return {
                ...prices,
                [getKeyForTablePrice(when, returnDate)]: {
                    status: EDynamicsDayStatus.HAS_DATA,
                    price: {
                        ...minSearchPrice,
                        roughly: false,
                    },
                    progress: 100,
                    fromSearch: true,
                },
            };
        }

        return prices || DEFAULT_PRICES;
    },
);

export default tableDynamicFinalPricesSelector;
