import {StoreInterface} from 'reducers/storeTypes';
import {IAviaTableDynamicsState} from 'reducers/avia/aviaPriceIndex/tableDynamic/reducer';

const tableDynamicSelector = (state: StoreInterface): IAviaTableDynamicsState =>
    state.avia.aviaPriceIndex.tableDynamics;

/**
 * Возвращает цены табличного представления динамики
 */
export const tableDynamicPricesSelector = (
    state: StoreInterface,
): IAviaTableDynamicsState['prices'] => tableDynamicSelector(state).prices;

/**
 * Возвращает статус запроса табличного представления динамики
 */
export const tableDynamicStatusSelector = (
    state: StoreInterface,
): IAviaTableDynamicsState['status'] => tableDynamicSelector(state).status;

/**
 * Возвращает ошибку запроса табличного представления динамики
 */
export const tableDynamicErrorSelector = (
    state: StoreInterface,
): IAviaTableDynamicsState['error'] => tableDynamicSelector(state).error;

/**
 * Возвращает поисковую форму для которой производится/производился запрос табличного представления динамики
 */
export const tableDynamicForSearchFormSelector = (
    state: StoreInterface,
): IAviaTableDynamicsState['forSearchForm'] =>
    tableDynamicSelector(state).forSearchForm;

/**
 * Возвращает фильтры для которых производится/производился запрос табличного представления динамики
 */
export const tableDynamicForFiltersSelector = (
    state: StoreInterface,
): IAviaTableDynamicsState['forFilters'] =>
    tableDynamicSelector(state).forFilters;
