import {
    ECarryOnType,
    IVariantPrice,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';
import {
    EFareFamilyTermCode,
    emptyFareFamilyKeys,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDFareFamily';
import {IAviaCarryOn} from 'types/avia/common/IAviaCarryOn';

import {INormalizedTDReference} from 'reducers/avia/utils/ticketDaemon/normalizeTDReference';

export default function denormalizeCarryOn(
    price: IVariantPrice,
    reference: INormalizedTDReference,
): Nullable<IAviaCarryOn>[][] {
    const {fareFamilies} = reference;
    const families = price.fare_families || emptyFareFamilyKeys;

    return families.map(segmentFamily =>
        segmentFamily.map(family => {
            if (!family) {
                return null;
            }

            const familyCarryOn =
                fareFamilies[family]?.terms?.[EFareFamilyTermCode.carryOn];

            if (!familyCarryOn) {
                return null;
            }

            return {
                limitedCarryOn:
                    familyCarryOn.carry_on_size_bucket === ECarryOnType.SMALL ??
                    false,
                size: familyCarryOn.size,
                places: familyCarryOn.places,
                weight: familyCarryOn.weight,
                included: Boolean(familyCarryOn.places),
            };
        }),
    );
}
