import {IVariantPrice} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';
import {
    emptyFareFamilyKeys,
    EFareFamilyTermCode,
    EFareFamilyAvailability,
    IFFChangingCarriageTermRule,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDFareFamily';

import {INormalizedTDReference} from 'reducers/avia/utils/ticketDaemon/normalizeTDReference';

/** используем 'обмен не доступен' если для перелета нет FareFamily */
const defaultNotAvailableChangingCarriage: IFFChangingCarriageTermRule = {
    availability: EFareFamilyAvailability.notAvailable,
};

const CHANGING_CARRIAGE_PRIORITY = {
    [EFareFamilyAvailability.notAvailable]: 1,
    [EFareFamilyAvailability.charge]: 2,
    [EFareFamilyAvailability.free]: 3,
};

export function getWorstChangingCarriage(
    changingCarriages: IFFChangingCarriageTermRule[],
): IFFChangingCarriageTermRule {
    return changingCarriages.length
        ? changingCarriages.reduce((worstItem, item) => {
              if (typeof worstItem === 'undefined') {
                  return item;
              }

              const availability =
                  CHANGING_CARRIAGE_PRIORITY[item?.availability] ?? 0;
              const worstAvailability =
                  CHANGING_CARRIAGE_PRIORITY[worstItem?.availability] ?? 0;

              return worstAvailability > availability ? item : worstItem;
          })
        : defaultNotAvailableChangingCarriage;
}

export function denormalizeChangingCarriage(
    price: IVariantPrice,
    reference: INormalizedTDReference,
): IFFChangingCarriageTermRule {
    const {fareFamilies} = reference;
    const families = price.fare_families || emptyFareFamilyKeys;

    const changingCarriages = families.flatMap(segmentFamily => {
        return segmentFamily.reduce<IFFChangingCarriageTermRule[]>(
            (arr, family) => {
                /** если family === null - для соответсвующего перелета нет информации по тарифу */
                const fareFamilyNotExist = family === null;

                if (fareFamilyNotExist) {
                    arr.push(defaultNotAvailableChangingCarriage);
                } else {
                    const familyChangingCarriage =
                        fareFamilies[family]?.terms?.[
                            EFareFamilyTermCode.changingCarriage
                        ];

                    if (familyChangingCarriage) {
                        arr.push(familyChangingCarriage);
                    }
                }

                return arr;
            },
            [],
        );
    });

    return getWorstChangingCarriage(changingCarriages);
}
