import {
    ICompany,
    IAlliance,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {INormalizedTDReference} from 'reducers/avia/utils/ticketDaemon/normalizeTDReference';

export interface IResultCompany {
    id: number;
    logoSvg: string;
    title: string;
    url: string;
    alliance: IAlliance | null;
    color?: string;
}

export function denormalizeCompany(
    company: ICompany,
    reference: INormalizedTDReference,
): IResultCompany {
    return {
        id: company.id,
        logoSvg: company.logoSvg,
        title: company.title,
        url: company.url,
        alliance:
            // eslint-disable-next-line no-eq-null
            company.alliance == null
                ? null
                : reference.alliances[company.alliance],
        color: company.color,
    };
}
