import {
    ISettlement,
    IStationType,
    TStationType,
} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {INormalizedTDReference} from 'reducers/avia/utils/ticketDaemon/normalizeTDReference';

export interface IResultAviaStation {
    code: string;
    id: number;
    phraseFrom: string;
    phraseIn: string;
    phraseTo: string;
    settlement?: ISettlement;
    stationId: number;
    stationType: IStationType;
    tType: TStationType;
    title: string;
}

export function denormalizeStation(
    stationId: number,
    reference: INormalizedTDReference,
): IResultAviaStation {
    const {
        code,
        id,
        phraseFrom,
        phraseIn,
        phraseTo,
        settlement,
        stationType,
        tType,
        title,
    } = reference.stations[stationId];

    return {
        code,
        id,
        phraseFrom,
        phraseIn,
        phraseTo,
        settlement: reference.settlements[settlement],
        stationId,
        stationType,
        tType,
        title,
    };
}
