import {TVariantFareFamilyKeys} from 'server/api/AviaTicketDaemonApi/types/IAviaTDFareFamily';

import {INormalizedTDReference} from 'reducers/avia/utils/ticketDaemon/normalizeTDReference';

export default function denormalizeTariffName(
    fareFamilyKeys: TVariantFareFamilyKeys | undefined,
    reference: INormalizedTDReference,
): string | null {
    if (!fareFamilyKeys) {
        return null;
    }

    let tariffName: string | null = null;

    for (const directionFamilyKeys of fareFamilyKeys) {
        for (const familyKey of directionFamilyKeys) {
            if (!familyKey) {
                return null;
            }

            const fareFamily = reference.fareFamilies[familyKey];

            if (!fareFamily) {
                return null;
            }

            if (tariffName) {
                if (fareFamily.tariffGroupName !== tariffName) {
                    return null;
                }
            } else {
                tariffName = fareFamily.tariffGroupName;
            }
        }
    }

    return tariffName;
}
