import {IAviaCarryOn} from 'types/avia/common/IAviaCarryOn';

export default function getWorstCarryOn(items: IAviaCarryOn[]): IAviaCarryOn {
    return items.reduce((worstCarryOn, carryOn) => {
        if (!worstCarryOn.weight) {
            return worstCarryOn;
        }

        if (!carryOn.weight) {
            return carryOn;
        }

        if (carryOn.weight < worstCarryOn.weight) {
            return carryOn;
        } else if (carryOn.weight === worstCarryOn.weight) {
            return carryOn.places < worstCarryOn.places
                ? carryOn
                : worstCarryOn;
        }

        return worstCarryOn;
    });
}
