import {IAviaSearchResultsSorting} from 'reducers/avia/search/results/reducer';
import {EAviaResultsSortType} from 'reducers/avia/search/results/EAviaResultsSortType';

import {IAviaInterestVariants} from 'selectors/avia/search/interest';
import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';
import {sortVariantsGroups} from 'selectors/avia/search/sorting/sortVariantsGroup';

import {PriceComparator} from 'utilities/currency/compare';

export interface IAviaSearchVariantsView {
    top: IAviaVariantGroup[];
    rest: IAviaVariantGroup[];
}

const TOP_VARIANTS_COUNT = 5;

const getUniqVariants = (
    variants: IAviaVariantGroup[],
    map: Record<string, boolean>,
    limit: number = 0,
): IAviaVariantGroup[] => {
    const result: IAviaVariantGroup[] = [];

    for (let i = 0; i < variants.length; i++) {
        const variant = variants[i];
        const {key} = variant;

        if (!map[key]) {
            map[key] = true;
            result.push(variant);

            if (limit && limit === result.length) {
                return result;
            }
        }
    }

    return result;
};

export function getAviaSearchVariantsView(
    variants: IAviaVariantGroup[],
    sorting: IAviaSearchResultsSorting,
    interest: IAviaInterestVariants,
    priceComparator: PriceComparator,
): IAviaSearchVariantsView {
    if (sorting.type === EAviaResultsSortType.INTEREST) {
        const keyMap: Record<string, boolean> = {};
        const cheapest = getUniqVariants(interest.cheapest, keyMap, 1)[0];
        const popular = getUniqVariants(interest.popular, keyMap, 1)[0];
        const comfy = getUniqVariants(interest.comfy, keyMap, 1)[0];
        const fromCompany = getUniqVariants(interest.fromCompany, keyMap, 1)[0];
        const boy = getUniqVariants(interest.boy, keyMap, 1)[0];

        const top = [cheapest, popular, comfy, fromCompany, boy].filter(
            Boolean,
        );

        const rest = getUniqVariants(variants, keyMap);

        return {
            top: sortVariantsGroups(
                top,
                {
                    type: EAviaResultsSortType.PRICE,
                    direction: sorting.direction,
                },
                priceComparator,
            ),
            rest,
        };
    }

    return {
        top: variants.slice(0, TOP_VARIANTS_COUNT),
        rest: variants.slice(TOP_VARIANTS_COUNT),
    };
}
