import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';
import {getCheapestFlights} from 'selectors/avia/utils/getCheapestFlights';

import {PriceComparator} from 'utilities/currency/compare';

export const getBoyFlights = (
    groups: IAviaVariantGroup[],
): IAviaVariantGroup[] => {
    if (!groups.length) {
        return [];
    }

    return groups.filter(group =>
        Boolean(group.cheapestVariantsByTariff.cheapest.price.boy),
    );
};

export const getBoyCheapestFlights = (
    groups: IAviaVariantGroup[],
    priceComparator: PriceComparator,
): IAviaVariantGroup[] => {
    return getCheapestFlights(getBoyFlights(groups), priceComparator);
};
