import {EAviaResultsSortType} from 'reducers/avia/search/results/EAviaResultsSortType';

import {
    IAviaVariantGroup,
    EAviaVariantGroupType,
} from 'selectors/avia/utils/denormalization/variantGroup';
import {sortVariantsGroups} from 'selectors/avia/search/sorting/sortVariantsGroup';

import {ESortDirection} from 'projects/avia/lib/comparators/TComparator';
import {compareVariantsByPrice} from 'projects/avia/lib/search/comparators/variantsPriceComparator';
import {PriceComparator} from 'utilities/currency/compare';

export function getCheapestFlights(
    groups: IAviaVariantGroup[],
    priceComparator: PriceComparator,
) {
    if (!groups.length) {
        return [];
    }

    const sortedByPrice = sortVariantsGroups(
        groups,
        {
            type: EAviaResultsSortType.PRICE,
            direction: ESortDirection.ASCENDING,
        },
        priceComparator,
    );
    const cheapest = sortedByPrice[0];
    const compare = compareVariantsByPrice(priceComparator);
    const nonCheapestIndex = sortedByPrice.findIndex(group =>
        compare(group, cheapest),
    );

    return (
        nonCheapestIndex === -1
            ? sortedByPrice
            : sortedByPrice.slice(0, nonCheapestIndex)
    ).map(item => ({
        ...item,
        type: EAviaVariantGroupType.cheapest,
    }));
}
