import {EOneWay} from 'server/services/AviaSearchService/types/IAviaParams';

import {IAviaContext} from 'reducers/avia/data-types';

import withTimeData from 'selectors/avia/utils/withTimeData';
import {getFastestFlights} from 'selectors/avia/utils/getFastestFlights';
import {getCheapestFlights} from 'selectors/avia/utils/getCheapestFlights';
import {withoutAirportChange} from 'selectors/avia/utils/withoutAirportChange';
import {
    EAviaVariantGroupType,
    IAviaVariantGroup,
} from 'selectors/avia/utils/denormalization/variantGroup';
import {getFlightsWithMinChanges} from 'selectors/avia/utils/getFlightsWithMinChanges';

import {PriceComparator} from 'utilities/currency/compare';

export function getComfyFlights(
    groups: IAviaVariantGroup[],
    context: IAviaContext,
    priceComparator: PriceComparator,
) {
    if (!groups.length) {
        return [];
    }

    const hasBackward = context.oneway === EOneWay.ROUND_TRIP;
    const flightsWithTimeInfo = groups.filter(group =>
        withTimeData(group, hasBackward),
    );
    const flightsWithMinChanges = getFlightsWithMinChanges(flightsWithTimeInfo);
    const flightsWithoutAirportChange = flightsWithMinChanges.filter(group =>
        withoutAirportChange(group, hasBackward),
    );
    const filteredFlights = flightsWithoutAirportChange.length
        ? flightsWithoutAirportChange
        : flightsWithMinChanges;
    const fastestFlights = getFastestFlights(filteredFlights, priceComparator);

    return getCheapestFlights(fastestFlights, priceComparator).map(item => ({
        ...item,
        type: EAviaVariantGroupType.comfy,
    }));
}
