import {
    IAviaVariantGroup,
    EAviaVariantGroupType,
} from 'selectors/avia/utils/denormalization/variantGroup';

export function getCompanyFlights(groups: IAviaVariantGroup[]) {
    return groups
        .filter(({variants}) => variants.some(({price}) => price.fromCompany))
        .map(item => ({
            ...item,
            type: EAviaVariantGroupType.aviacompany,
        }));
}
