import {EAviaResultsSortType} from 'reducers/avia/search/results/EAviaResultsSortType';

import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';
import {sortVariantsGroups} from 'selectors/avia/search/sorting/sortVariantsGroup';

import {ESortDirection} from 'projects/avia/lib/comparators/TComparator';
import {PriceComparator} from 'utilities/currency/compare';

export function getFastestFlights(
    groups: IAviaVariantGroup[],
    priceComparator: PriceComparator,
) {
    if (!groups.length) {
        return [];
    }

    const sortedByDuration = sortVariantsGroups(
        groups,
        {
            type: EAviaResultsSortType.DURATION,
            direction: ESortDirection.ASCENDING,
        },
        priceComparator,
    );

    const {flightsTotalDuration: minFlightDuration} = sortedByDuration[0];

    // 15 минут или 20% от минимальной продолжительности полета
    const maxFlightDurationDelta = Math.max(
        15 * 60 * 1000,
        minFlightDuration * 0.2,
    );
    const nonFastestIndex = sortedByDuration.findIndex(
        ({flightsTotalDuration}) =>
            flightsTotalDuration - minFlightDuration > maxFlightDurationDelta,
    );

    return nonFastestIndex === -1
        ? sortedByDuration
        : sortedByDuration.slice(0, nonFastestIndex);
}
