import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';

function getMaxChangesInGroup(group: IAviaVariantGroup) {
    const {forward, backward} = group.variants[0];

    return Math.max(forward.length - 1, backward.length - 1);
}

function getMinChangesInGroups(groups: IAviaVariantGroup[]) {
    let minChanges = 9;

    for (let i = 0; i < groups.length; i++) {
        minChanges = Math.min(minChanges, getMaxChangesInGroup(groups[i]));

        if (minChanges === 0) {
            return 0;
        }
    }

    return minChanges;
}

export function getFlightsWithMinChanges(groups: IAviaVariantGroup[]) {
    const minChanges = getMinChangesInGroups(groups);
    const limitChanges = minChanges + 1;

    return groups.filter(group => getMaxChangesInGroup(group) <= limitChanges);
}
