import {IAviaPopularFlights} from 'selectors/avia/search/popularFlights';
import {
    IAviaVariantGroup,
    EAviaVariantGroupType,
} from 'selectors/avia/utils/denormalization/variantGroup';

export function getPopularFlights(
    groups: IAviaVariantGroup[],
    popularFlights: IAviaPopularFlights,
) {
    const {forward, backward, hasForward, hasBackward} = popularFlights;

    if (!hasForward || !groups.length) {
        return [];
    }

    return groups
        .filter(item => {
            const {forwardNumber, backwardNumber} = item.variants[0];
            const forwardIsPopular = Boolean(forward[forwardNumber]);
            const backwardIsPopular = hasBackward
                ? backwardNumber && Boolean(backward[backwardNumber])
                : true;

            return forwardIsPopular && backwardIsPopular;
        })
        .map(item => ({
            ...item,
            type: EAviaVariantGroupType.popular,
        }));
}
