import {compareResultVariants} from 'projects/avia/lib/order/comparators/compareResultVariants';
import {PriceComparator} from 'utilities/currency/compare';

import {IResultAviaVariant} from './denormalization/variant';

export function sortResultVariants(
    variants: IResultAviaVariant[],
    priceComparator: PriceComparator,
): IResultAviaVariant[] {
    const compare = compareResultVariants(priceComparator);

    return [...variants].sort(({price: a}, {price: b}) => compare(a, b));
}
