import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';

export default function withTimeData(
    {variants}: IAviaVariantGroup,
    hasBackward: boolean,
) {
    return variants.some(({forward, backward}) => {
        const everyForwardWithTime = forward.every(
            flight => flight.arrival && flight.departure,
        );
        const everyBackwardWithTime =
            !hasBackward ||
            backward.every(flight => flight.arrival && flight.departure);

        return everyForwardWithTime && everyBackwardWithTime;
    });
}
