import {IResultAviaFlight} from 'selectors/avia/utils/denormalization/flight';
import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';

function airportFilter(flights: IResultAviaFlight[]) {
    if (flights.length < 2) {
        return true;
    }

    for (let i = 0; i < flights.length - 1; i++) {
        if (flights[i].to.id !== flights[i + 1].from.id) {
            return false;
        }
    }

    return true;
}

// Вернёт перелёты без смены аэропорта
export function withoutAirportChange(
    group: IAviaVariantGroup,
    hasBackward: boolean,
) {
    const {forward, backward} = group.variants[0];

    return airportFilter(forward) && (!hasBackward || airportFilter(backward));
}
