import {createSelector} from 'reselect';

import TValidDataForRequestDynamic from 'types/avia/dynamic/TValidDataForRequestDynamic';

import {
    aviaWeekPricesForFiltersSelector,
    aviaWeekPricesForIntervalSelector,
    aviaWeekPricesForSearchFormSelector,
} from 'selectors/avia/weekPrices/aviaWeekPricesSelectors';

/**
 * Возвращает данные о том с какими данными производился/производится запрос к динамике
 */
const aviaWeekPricesCurrentRequestParamsSelector = createSelector(
    aviaWeekPricesForSearchFormSelector,
    aviaWeekPricesForFiltersSelector,
    aviaWeekPricesForIntervalSelector,
    (searchForm, filters, interval): TValidDataForRequestDynamic | null => {
        if (!searchForm || !filters || !interval) {
            return null;
        }

        return {
            searchForm,
            filters,
            interval,
        };
    },
);

export default aviaWeekPricesCurrentRequestParamsSelector;
