import {createSelector} from 'reselect';

import {EDynamicsDayStatus} from 'projects/avia/components/Dynamics/types/IDynamicsDay';

import {TDynamicsDaysInfo} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import {aviaWeekPricesPriceSelector} from 'selectors/avia/weekPrices/aviaWeekPricesSelectors';
import {getAviaMinSearchPrice} from 'selectors/avia/search/getMinSearchPrice';
import {getAviaSearchFilters} from 'selectors/avia/search/aviaSearchResultsSelector';
import {aviaContextSearchFormSelector} from 'selectors/avia/context/aviaContextSearchFormSelector';
import aviaWeekPricesCurrentRequestParamsSelector from 'selectors/avia/weekPrices/aviaWeekPricesCurrentRequestParamsSelector';

import isDateRobot from 'utilities/dateUtils/isDateRobot';
import isCompatibleSearchForm from 'projects/avia/lib/dynamic/isCompatibleSearchForm';
import isSameSearchFilters from 'projects/avia/lib/dynamic/isSameSearchFilters';

const DEFAULT_PRICES = {};

/**
 * Возвращает итоговый объект с ценами недельной динамики.
 * Если будет возможно, то к ценам динамики будет добавлена актуальная цена с поиска.
 */
export const aviaWeekPricesFinalPricesSelector = createSelector(
    aviaWeekPricesPriceSelector,
    aviaWeekPricesCurrentRequestParamsSelector,
    getAviaMinSearchPrice,
    getAviaSearchFilters,
    aviaContextSearchFormSelector,
    (
        prices,
        currentRequestParams,
        minSearchPrice,
        filters,
        searchForm,
    ): TDynamicsDaysInfo => {
        const {when} = searchForm;

        if (
            minSearchPrice &&
            isDateRobot(when) &&
            currentRequestParams &&
            isCompatibleSearchForm(
                searchForm,
                currentRequestParams.searchForm,
            ) &&
            isSameSearchFilters(filters, currentRequestParams.filters)
        ) {
            return {
                ...prices,
                [when]: {
                    status: EDynamicsDayStatus.HAS_DATA,
                    price: {
                        ...minSearchPrice,
                        roughly: false,
                    },
                    progress: 100,
                    fromSearch: true,
                },
            };
        }

        return prices || DEFAULT_PRICES;
    },
);
