import {createSelector} from 'reselect';

import {IDataForRequestDynamic} from 'types/avia/dynamic/IDataForRequestDynamic';

import {aviaWeekPricesSearchFormSelector} from 'selectors/avia/weekPrices/aviaWeekPricesSearchFormSelector';
import {aviaWeekPricesFiltersSelector} from 'selectors/avia/weekPrices/aviaWeekPricesFiltersSelector';

import isDateRobot from 'utilities/dateUtils/isDateRobot';
import dynamicsWeekDates from 'projects/avia/components/Dynamics/utilities/dynamicsWeekDates';

/**
 * Возвращает данные для запроса динамики цен на неделю.
 * Блок с этими ценами отображается на поиске.
 *
 * Вернет null, если данные отсутствуют.
 */
export const aviaWeekPricesRequestParamsSelector = createSelector(
    aviaWeekPricesFiltersSelector,
    aviaWeekPricesSearchFormSelector,
    (filters, searchForm): IDataForRequestDynamic | null => {
        const {when} = searchForm;

        if (!isDateRobot(when)) {
            return null;
        }

        const dates = dynamicsWeekDates(when);
        const interval = {
            startDate: dates[0],
            endDate: dates[dates.length - 1],
        };

        return {
            filters,
            searchForm,
            interval,
        };
    },
);
