import {StoreInterface} from 'reducers/storeTypes';
import {IAviaWeekPricesState} from 'reducers/avia/aviaPriceIndex/weekPrices/reducer';

/**
 * Возвращает все состояние цен на ближайшую неделю
 */
const aviaWeekPricesSelector = (state: StoreInterface): IAviaWeekPricesState =>
    state.avia.aviaPriceIndex.weekPrices;

/**
 * Возвращает цены
 */
export const aviaWeekPricesPriceSelector = (
    state: StoreInterface,
): IAviaWeekPricesState['prices'] => aviaWeekPricesSelector(state).prices;

/**
 * Возвращает статус запроса к динамике
 */
export const aviaWeekPricesStatusSelector = (
    state: StoreInterface,
): IAviaWeekPricesState['status'] => aviaWeekPricesSelector(state).status;

/**
 * Возвращает поисковую форму, для которой произведен/производится запрос к динамике
 */
export const aviaWeekPricesForSearchFormSelector = (
    state: StoreInterface,
): IAviaWeekPricesState['forSearchForm'] =>
    aviaWeekPricesSelector(state).forSearchForm;

/**
 * Возвращает фильтры, для которых произведен/производится запрос к динамике
 */
export const aviaWeekPricesForFiltersSelector = (
    state: StoreInterface,
): IAviaWeekPricesState['forFilters'] =>
    aviaWeekPricesSelector(state).forFilters;

/**
 * Возвращает интервал, для которого произведен/производится запрос к динамике
 */
export const aviaWeekPricesForIntervalSelector = (
    state: StoreInterface,
): IAviaWeekPricesState['forInterval'] =>
    aviaWeekPricesSelector(state).forInterval;
