import createTypedStructuredSelector from '../../../utilities/createTypedStructuredSelector';

export default createTypedStructuredSelector({
    popularDirections: state => {
        if (!state.buses.popularDirections.value) {
            return null;
        }

        const popular = state.buses.popularDirections.value.map(direction => {
            const price = direction.prices.sort(
                (a, b) => a.amount - b.amount,
            )[0];

            return {
                from: direction.from,
                to: direction.to,
                price,
            };
        });

        if (popular.length) {
            return popular;
        }

        return null;
    },
    point: state => state.buses.popularDirections.point,
    isFetched: state => state.buses.popularDirections.isFetched,
});
