import {StoreInterface} from 'reducers/storeTypes';

import nonceSelector from 'selectors/common/nonceSelector';
import searchSegmentsStatsSelector from 'selectors/buses/search/searchSegmentsStatsSelector';

import createTypedStructuredSelector from '../../../utilities/createTypedStructuredSelector';

export default createTypedStructuredSelector({
    directionData: (state: StoreInterface) => state.buses.directionPage,
    searchStats: searchSegmentsStatsSelector,
    bookingInfo: (state: StoreInterface) => state.buses.search.bookingInfo,
    nonce: nonceSelector,
});
