import {createSelector} from 'reselect';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {IBusesSearchFormPointField} from 'projects/buses/components/SearchForm/types';
import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import {StoreInterface} from 'reducers/storeTypes';

import getSearchInformationHumanStartDate from 'utilities/searchForm/getSearchInformationHumanStartDate';

import * as i18nBlock from 'i18n/trains-search-information';

export default createSelector(
    (state: StoreInterface) =>
        state.buses.searchForm[ESearchFormFieldName.FROM],
    (state: StoreInterface) => state.buses.searchForm[ESearchFormFieldName.TO],
    (state: StoreInterface) =>
        state.buses.searchForm[ESearchFormFieldName.START_DATE],
    (
        from?: IBusesSearchFormPointField,
        to?: IBusesSearchFormPointField,
        startDate?: WHEN_SPECIAL_VALUE | string | null,
    ): {
        from: string;
        to: string;
        when: string;
    } => ({
        from: from?.inputValue || i18nBlock.fromDashPlaceholder(),
        to: to?.inputValue || i18nBlock.toDashPlaceholder(),
        when: getSearchInformationHumanStartDate(startDate),
    }),
);
