import {createSelector} from 'reselect';

import {IBusesSearchSegmentsStore} from 'reducers/buses/types/search/IBusesSearchSegmentsStore';

import {StoreInterface} from 'reducers/storeTypes';

import getSortComparator from 'selectors/buses/search/utilities/sort/getSortComparator';

export default createSelector(
    (state: StoreInterface) => state.buses.search.segments,
    (state: StoreInterface) => state.buses.search.sort,
    (segmentsInfo, sort): IBusesSearchSegmentsStore => {
        const {value: prevSegments, ...restSegmentsInfo} = segmentsInfo;

        if (!prevSegments) {
            return {
                value: null,
                ...restSegmentsInfo,
            };
        }

        const segments = [...prevSegments];

        const sortedSegments = segments.sort(getSortComparator(sort));

        return {
            value: sortedSegments,
            ...restSegmentsInfo,
        };
    },
);
