import {createSelector} from 'reselect';

import {EBusesDirectionBlock} from 'projects/buses/constants/direction/EBusesDirectionBlock';

import {IBusesSegmentsBlock} from 'types/buses/direction/IBusesSegmentsBlock';

import {StoreInterface} from 'reducers/storeTypes';

export interface IBusesSearchSegmentsStatsSelector {
    minPrice: number;
    maxPrice: number;
}

export default createSelector(
    (state: StoreInterface) => state.buses.directionPage?.data?.blocks,
    (blocks): IBusesSearchSegmentsStatsSelector | null => {
        const segments = blocks?.find(
            (block): block is IBusesSegmentsBlock =>
                block.type === EBusesDirectionBlock.BUSES_SEGMENTS,
        )?.data.segments;

        if (!segments?.length) {
            return null;
        }

        const sortedByPriceSegments = [...segments].sort(
            (segmentA, segmentB) => segmentA.price.value - segmentB.price.value,
        );

        return {
            minPrice: Math.round(sortedByPriceSegments[0].price.value),
            maxPrice: Math.round(
                sortedByPriceSegments[sortedByPriceSegments.length - 1].price
                    .value,
            ),
        };
    },
);
