import {StoreInterface} from 'reducers/storeTypes';

import searchSegmentsSelector from 'selectors/buses/search/searchSegmentsSelector';
import searchFiltersSelector from 'selectors/buses/search/searchFiltersSelector';
import nonceSelector from 'selectors/common/nonceSelector';
import searchSortsSelector from 'selectors/buses/search/searchSortSelector';
import {contextStateSelector} from 'selectors/buses/context/contextSelector';

import createTypedStructuredSelector from '../../../utilities/createTypedStructuredSelector';

export default createTypedStructuredSelector({
    contextInfo: contextStateSelector,
    segmentsInfo: searchSegmentsSelector,
    sortInfo: searchSortsSelector,
    filtersInfo: searchFiltersSelector,
    bookingInfo: (state: StoreInterface) => state.buses.search.bookingInfo,
    calendarInfo: (state: StoreInterface) => state.buses.search.calendar,
    nonce: nonceSelector,
});
