import {createSelector} from 'reselect';

import {IBusesSearchSortStore} from 'reducers/buses/types/search/IBusesSearchSortStore';
import {EBusesSortType} from 'types/buses/search/EBusesSortType';

import {StoreInterface} from 'reducers/storeTypes';

import searchSegmentsSelector from 'selectors/buses/search/searchSegmentsSelector';
import getAvailableSorts from 'selectors/buses/search/utilities/sort/getAvailableSorts';

export interface IBusesSearchSortSelector {
    sort: IBusesSearchSortStore;
    availableSorts: EBusesSortType[];
}

export default createSelector(
    (state: StoreInterface) => state.buses.search.sort,
    searchSegmentsSelector,
    (sort, segments): IBusesSearchSortSelector => ({
        sort,
        availableSorts: getAvailableSorts(segments.value || []),
    }),
);
