import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';
import {IBusesSegment} from 'types/buses/search/IBusesSegment';
import {ETimeOfDay} from 'utilities/dateUtils/types';

import isSegmentAppliesToFilterOption from 'selectors/buses/search/utilities/filters/isSegmentAppliesToOption';

export default function getAvailableFilterOptions<
    T extends string | ETimeOfDay,
>({
    segments,
    type,
    options,
    hiddenSegmentsIdsWithoutThisFilter,
}: {
    segments: IBusesSegment[];
    type: EBusesFilter;
    options: T[];
    hiddenSegmentsIdsWithoutThisFilter: Set<string>;
}): T[] {
    const visibleSegmentsWithoutThisFilter = segments.filter(
        ({id}) => !hiddenSegmentsIdsWithoutThisFilter.has(id),
    );

    return options.filter(option =>
        visibleSegmentsWithoutThisFilter.some(segment =>
            isSegmentAppliesToFilterOption(segment, {
                type,
                value: option as any,
            }),
        ),
    );
}
