import {IBusesSegment} from 'types/buses/search/IBusesSegment';
import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';
import {TBusesFilterTypeAndValues} from 'types/buses/search/filters/TBusesFilterTypeAndValue';

import isSegmentAppliesToOption from 'selectors/buses/search/utilities/filters/isSegmentAppliesToOption';

export default function getHiddenSegmentsIdsByFilter(
    segments: IBusesSegment[],
    typeAndValues: TBusesFilterTypeAndValues,
): Set<string> {
    return segments.reduce<Set<string>>((accHiddenSegmentsIdsSet, segment) => {
        if (!typeAndValues.values?.length) {
            return accHiddenSegmentsIdsSet;
        }

        const isSegmentAppliesToAnyOption =
            typeAndValues.type === EBusesFilter.PRICE
                ? isSegmentAppliesToOption(segment, {
                      type: typeAndValues.type,
                      value: typeAndValues.values,
                  })
                : typeAndValues.values.some(option =>
                      isSegmentAppliesToOption(segment, {
                          type: typeAndValues.type,
                          value: option as any,
                      }),
                  );

        if (!isSegmentAppliesToAnyOption) {
            accHiddenSegmentsIdsSet.add(segment.id);
        }

        return accHiddenSegmentsIdsSet;
    }, new Set<string>());
}
