import first from 'lodash/first';
import last from 'lodash/last';

import {IBusesSegment} from 'types/buses/search/IBusesSegment';

import priceComparator from 'selectors/buses/search/utilities/sort/priceComparator';

export default function getPriceFilterRange(
    segments: IBusesSegment[],
): [number, number] | null {
    const sortedSegments = [...segments].sort(priceComparator);

    const cheapestSegment = first(sortedSegments);
    const mostExpensiveSegment = last(sortedSegments);

    if (
        !cheapestSegment?.price.amount ||
        !mostExpensiveSegment?.price.amount ||
        cheapestSegment.price.amount === mostExpensiveSegment.price.amount
    ) {
        return null;
    }

    return [
        Math.floor(cheapestSegment.price.amount),
        Math.ceil(mostExpensiveSegment.price.amount),
    ];
}
