import uniq from 'lodash/uniq';

import {IBusesSegment} from 'types/buses/search/IBusesSegment';
import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';

export default function getStationFilterOptions(
    segments: IBusesSegment[],
    type: EBusesFilter.DEPARTURE_STATION | EBusesFilter.ARRIVAL_STATION,
): string[] {
    const field = type === EBusesFilter.DEPARTURE_STATION ? 'from' : 'to';

    return uniq(segments.map(({[field]: point}) => point.title));
}
