import moment from 'moment';
import intersection from 'lodash/intersection';

import {TIMES_OF_DAY} from 'utilities/dateUtils/constants';

import {IBusesSegment} from 'types/buses/search/IBusesSegment';
import {ETimeOfDay} from 'utilities/dateUtils/types';
import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';
import {isNotNull} from 'types/utilities';

import {getTimeOfDay} from 'utilities/dateUtils';

export default function getTimeOfDayFilterOptions(
    segments: IBusesSegment[],
    type: EBusesFilter.DEPARTURE_TIME | EBusesFilter.ARRIVAL_TIME,
): ETimeOfDay[] {
    const field =
        type === EBusesFilter.DEPARTURE_TIME ? 'departureTime' : 'arrivalTime';

    const timesOfDay = segments
        .map(({[field]: time, from, to}) => {
            const timezone =
                type === EBusesFilter.DEPARTURE_TIME
                    ? from.timezone
                    : to.timezone;

            if (!time) {
                return null;
            }

            return getTimeOfDay(moment(time).tz(timezone).hour());
        })
        .filter(isNotNull);

    return intersection(TIMES_OF_DAY, timesOfDay);
}
