import moment from 'moment';

import {IBusesSegment} from 'types/buses/search/IBusesSegment';
import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';
import {TBusesFilterTypeAndValue} from 'types/buses/search/filters/TBusesFilterTypeAndValue';

import {getTimeOfDay} from 'utilities/dateUtils';

export default function isSegmentAppliesToFilterOption(
    segment: IBusesSegment,
    typeAndValue: TBusesFilterTypeAndValue,
): boolean {
    if (typeAndValue.type === EBusesFilter.PRICE) {
        if (!typeAndValue.value) {
            return true;
        }

        const [minPrice, maxPrice] = typeAndValue.value;

        return (
            segment.price.amount >= Number(minPrice) &&
            segment.price.amount <= Number(maxPrice)
        );
    }

    if (typeAndValue.type === EBusesFilter.DEPARTURE_TIME) {
        const segmentTimeOfDay = getTimeOfDay(
            moment(segment.departureTime).tz(segment.from.timezone).hour(),
        );

        return segmentTimeOfDay === typeAndValue.value;
    }

    if (typeAndValue.type === EBusesFilter.ARRIVAL_TIME) {
        if (!segment.arrivalTime) {
            return false;
        }

        const segmentTimeOfDay = getTimeOfDay(
            moment(segment.arrivalTime).tz(segment.to.timezone).hour(),
        );

        return segmentTimeOfDay === typeAndValue.value;
    }

    if (typeAndValue.type === EBusesFilter.DEPARTURE_STATION) {
        return typeAndValue.value === segment.from.title;
    }

    return typeAndValue.value === segment.to.title;
}
