import moment from 'moment';

import {IBusesSegment} from 'types/buses/search/IBusesSegment';

/**
 * Сравнивает сегменты по времени прибытия.
 */
export default function arrivalComparator(
    segmentA: IBusesSegment,
    segmentB: IBusesSegment,
): number {
    if (
        !segmentA.arrivalTime ||
        !segmentB.arrivalTime ||
        segmentA.arrivalTime === segmentB.arrivalTime
    ) {
        return 0;
    }

    return moment(segmentA.arrivalTime).isAfter(moment(segmentB.arrivalTime))
        ? 1
        : -1;
}
