import moment from 'moment';

import {IBusesSegment} from 'types/buses/search/IBusesSegment';

/**
 * Сравнивает сегменты по времени отправления.
 */
export default function departureComparator(
    segmentA: IBusesSegment,
    segmentB: IBusesSegment,
): number {
    if (segmentA.departureTime === segmentB.departureTime) {
        return 0;
    }

    return moment(segmentA.departureTime).isAfter(
        moment(segmentB.departureTime),
    )
        ? 1
        : -1;
}
