import {IBusesSegment} from 'types/buses/search/IBusesSegment';

/**
 * Сравнивает сегменты по времени в пути.
 */
export default function durationComparator(
    segmentA: IBusesSegment,
    segmentB: IBusesSegment,
): number {
    if (
        !segmentA.duration ||
        !segmentB.duration ||
        segmentA.duration === segmentB.duration
    ) {
        return 0;
    }

    return segmentA.duration > segmentB.duration ? 1 : -1;
}
