import {IBusesSegment} from 'types/buses/search/IBusesSegment';
import {EBusesSortType} from 'types/buses/search/EBusesSortType';

export default function getAvailableSorts(
    segments: IBusesSegment[],
): EBusesSortType[] {
    const sortOptions: Record<EBusesSortType, Set<number | string>> = {
        [EBusesSortType.DEPARTURE]: new Set<string>(),
        [EBusesSortType.ARRIVAL]: new Set<string>(),
        [EBusesSortType.DURATION]: new Set<number>(),
        [EBusesSortType.PRICE]: new Set<number>(),
    };

    for (const segment of segments) {
        sortOptions[EBusesSortType.DEPARTURE].add(segment.departureTime);

        if (segment.arrivalTime) {
            sortOptions[EBusesSortType.ARRIVAL].add(segment.arrivalTime);
        }

        sortOptions[EBusesSortType.PRICE].add(segment.price.amount);

        if (segment.duration) {
            sortOptions[EBusesSortType.DURATION].add(segment.duration);
        }

        if (Object.values(sortOptions).every(options => options.size > 1)) {
            break;
        }
    }

    return (Object.entries(sortOptions) as [EBusesSortType, Set<number>][])
        .filter(([_, options]) => options.size > 1)
        .map(([sortType, _]) => sortType);
}
