import {EBusesSortType} from 'types/buses/search/EBusesSortType';
import {IBusesSegment} from 'types/buses/search/IBusesSegment';
import {IBusesSearchSortStore} from 'reducers/buses/types/search/IBusesSearchSortStore';
import {ESortDirection} from 'types/common/sort/ESortDirection';

import departureComparator from 'selectors/buses/search/utilities/sort/departureComparator';
import arrivalComparator from 'selectors/buses/search/utilities/sort/arrivalComparator';
import priceComparator from 'selectors/buses/search/utilities/sort/priceComparator';
import durationComparator from 'selectors/buses/search/utilities/sort/durationComparator';

/**
 * Сравнивает сегменты по заданному типу сортировки.
 */
export default function getSegmentsSortOrder(
    {type, direction}: IBusesSearchSortStore,
    segmentA: IBusesSegment,
    segmentB: IBusesSegment,
): number {
    if (type === EBusesSortType.DEPARTURE) {
        return departureComparator(segmentA, segmentB);
    }

    if (type === EBusesSortType.ARRIVAL) {
        if (!segmentA.arrivalTime && !segmentB.arrivalTime) {
            return 0;
        }

        if (!segmentA.arrivalTime) {
            return direction === ESortDirection.ASC ? 1 : -1;
        }

        if (!segmentB.arrivalTime) {
            return direction === ESortDirection.ASC ? -1 : 1;
        }

        return arrivalComparator(segmentA, segmentB);
    }

    if (type === EBusesSortType.PRICE) {
        return priceComparator(segmentA, segmentB);
    }

    if (!segmentA.duration && !segmentB.duration) {
        return 0;
    }

    if (!segmentA.duration) {
        return direction === ESortDirection.ASC ? 1 : -1;
    }

    if (!segmentB.duration) {
        return direction === ESortDirection.ASC ? -1 : 1;
    }

    return durationComparator(segmentA, segmentB);
}
