import {IBusesSegment} from 'types/buses/search/IBusesSegment';
import {EBusesSortDirection} from 'types/buses/search/EBusesSortType';
import {IBusesSearchSortStore} from 'reducers/buses/types/search/IBusesSearchSortStore';

import getSegmentsSortOrder from 'selectors/buses/search/utilities/sort/getSegmentsSortOrder';
import priceComparator from 'selectors/buses/search/utilities/sort/priceComparator';
import departureComparator from 'selectors/buses/search/utilities/sort/departureComparator';
import arrivalComparator from 'selectors/buses/search/utilities/sort/arrivalComparator';
import durationComparator from 'selectors/buses/search/utilities/sort/durationComparator';
import idComparator from 'selectors/buses/search/utilities/sort/idComparator';

/**
 * Возвращает функцию для сравнения сегментов.
 *
 * Если сегменты не отличаются по основному признаку сортировки, то сравниваем их по другим признакам.
 */
export default function getSortComparator(
    sort: IBusesSearchSortStore,
): (segmentA: IBusesSegment, segmentB: IBusesSegment) => number {
    return (segmentA: IBusesSegment, segmentB: IBusesSegment): number => {
        const baseSortOrder = getSegmentsSortOrder(sort, segmentA, segmentB);

        if (baseSortOrder) {
            return (
                baseSortOrder *
                (sort.direction === EBusesSortDirection.ASC ? 1 : -1)
            );
        }

        return (
            priceComparator(segmentA, segmentB) ||
            departureComparator(segmentA, segmentB) ||
            arrivalComparator(segmentA, segmentB) ||
            durationComparator(segmentA, segmentB) ||
            idComparator(segmentA, segmentB)
        );
    };
}
