import {IBusesSegment} from 'types/buses/search/IBusesSegment';

/**
 * Сравнивает сегменты по цене.
 */
export default function priceComparator(
    segmentA: IBusesSegment,
    segmentB: IBusesSegment,
): number {
    if (segmentA.price.amount === segmentB.price.amount) {
        return 0;
    }

    return segmentA.price.amount > segmentB.price.amount ? 1 : -1;
}
