import {BUSES_SEARCH_FORM_NAME} from 'constants/reduxForm';

import {previousFormValuesByFormNameSelector} from 'selectors/common/previousFormValuesSelector';
import {fromFieldSelector} from 'selectors/buses/searchForm/fromFieldSelector';
import {toFieldSelector} from 'selectors/buses/searchForm/toFieldSelector';
import {startDateSelector} from 'selectors/buses/searchForm/startDateSelector';

import createTypedStructuredSelector from '../../../utilities/createTypedStructuredSelector';

export default createTypedStructuredSelector({
    fromField: fromFieldSelector,
    toField: toFieldSelector,
    startDateField: startDateSelector,
    previousFormValues: state =>
        previousFormValuesByFormNameSelector(state, BUSES_SEARCH_FORM_NAME),
    searchSuggests: state => state.buses.searchSuggests,
    calendar: state => state.buses.calendar.value,
});
